attribute vec4 position; //drawcall
attribute vec3 normal;    //drawcall
uniform mat4 view;         //common
uniform mat4 proj;         //common
varying vec3 n; 
varying float radi; 
uniform vec3 pos2; 
uniform float size_mul;

void main()
{	
	vec3 pos = position.xyz*size_mul+pos2; 
	gl_Position = proj*view*vec4(pos.xyz, 1.0);
	n = normalize(normal.xyz); 

   radi = 1.0-clamp(length(pos/350.0), 0.0, 1.0);
   radi *= radi*radi*radi;
  
}	

//FRAGMENT
varying vec3 n;  
varying float radi; 
uniform sampler2D Texture0; 
uniform float exponent;
uniform float a; 

#define PI 3.141592653589793

vec4 RadialLookup(sampler2D tex, vec3 a_coords)
{
   float r = length(a_coords);
   float lon = atan(a_coords.z, a_coords.x);
   float lat = acos(a_coords.y / r); // Remove divide if a_coords is normalized
   const vec2 rads = vec2(1.0 / (PI * 2.0), 1.0 / PI);
   vec2 sphereCoords = vec2(lon, lat) * rads;  
   return texture2D(tex, sphereCoords);
};

void main()
{
   vec4 c = RadialLookup(Texture0, normalize(n.xyz));
   gl_FragColor = pow(c, 2.2);//+pow(c,1.2025);
   gl_FragColor = vec4(.5+.5*cos((a+.5)*3.141592/1.0));
   gl_FragColor = vec4(1.);
   gl_FragColor *= a*.40;//vec4(a-.5)*.2);

   
   gl_FragColor.a += a*radi*3.0;
   gl_FragColor.a = clamp(gl_FragColor.a, 0.0, 1.0); 
   //gl_FragColor = pow(c, 2.2);//vec4(1.0/2.2));   
}